<?php
class assistRequestPaymentForm
{
    private $formData = array();
    private $formId = 'assistForm';
    private $formMethod = 'post';
    private $formAction = '';
    private $submitLabel = 'submit';

    public function setShopId($shopId)
    {
        $this->formData['Merchant_ID'] = $shopId;
    }


    public function setShopPaymentId($shopPaymentId)
    {
        $this->formData['OrderNumber'] = $shopPaymentId;
    }

    public function setAmount($amount)
    {
        $this->formData['OrderAmount'] = $amount;
    }

    public function setCurrency($currency)
    {
        $this->formData['OrderCurrency'] = $currency;
    }

    public function setPurpose($purpose)
    {
        $this->formData['OrderComment'] = $purpose;
    }

    public function setUserEmail($userEmail)
    {
        $this->formData['Email'] = $userEmail;
		
    }

    public function setUserFirsname($userFirsname)
    {
        $this->formData['FirstName'] = $userFirsname;
		
    }


    public function setUserLastname($userLastname)
    {
        $this->formData['LastName'] = $userLastname;
		
    }

    public function setUserHomephone($userHomephone)
    {
        $this->formData['MobilePhone'] =$userHomephone;
		
    }


    public function setUserData(array $userData)
    {
        foreach ($userData as $name => $value)
            $this->formData['spUserData'.$name] = $value;
    }

    public function setLanguage($language)
    {
        $this->formData['Language'] = $language;
    }

    public function setSuccessUrl($successUrl)
    {
        $this->formData['URL_RETURN_OK'] = $successUrl;
    }

    public function setFailUrl($failUrl)
    {
        $this->formData['URL_RETURN_NO'] = $failUrl;
    }

    public function setCheckValue($uc_assist_shop_secret, $uc_assist_shop_id, $order_id, $order_total, $currency) {
		$this->formData['CheckValue'] = strtoupper(md5(strtoupper(md5($uc_assist_shop_secret).md5($uc_assist_shop_id.$order_id.$order_total.$currency))));
	}

    public function setSuccessMethod($successMethod){}
    public function setFailMethod($failMethod){}
    public function setIpnUrl($ipnUrl){}
    public function setIpnMethod($ipnMethod){}
    public function setAllowedPaymentSystems(array $allowedPaymentSystems){}
    public function setForbiddenPaymentSystems(array $forbiddenPaymentSystems){}

    public function setMethod($method)
    {
        if ($method != 'get' && $method != 'post')
            $method = 'post';
        $this->formMethod = $method;
    }

    public function setSubmitLabel($label)
    {
        $this->submitLabel = $label;
    }

    public function renderForm()
    { 
        $form  = '<form id ="'.$this->formId.'" action="https://'.variable_get('uc_assist_server_name').'/pay/order.cfm" method="'.$this->formMethod.'">';
        foreach ($this->formData as $name => $value)
            $form .= $this->renderInputField($name, $value);
        $form .= '<input type="hidden" name="src" value="1"/>';
        //$form .= '<input type="submit" name="Submit"  value="'.$this->submitLabel.'"/>';
        $form .= '</form>Please wait...';
        $form .= '<script type="text/javascript"> document.forms["'.$this->formId.'"].submit(); </script>';
        return $form;
    }

    private function renderInputField($name, $value)
    {
        return '<input type="hidden" name="'.$name.'" value="'.$value.'" />';
    }
}
?>